<?php defined('SYSPATH') or die('No direct script access.');

class view_core 
{
  protected $filename = FALSE;
  protected $data = array();

  public function __construct($name = NULL)
  {
    if (is_string($name) AND $name !== '')
    {
      $this->filename = $name;
    }
  }

  public function __toString()
  {
    return $this->render();
  }

  public function __set($key, $value)
  {
    if ( ! isset($this->$key))
    {
      $this->data[$key] = $value;
    }
  }

  public function __get($key)
  {
    if (isset($this->data[$key]))
      return $this->data[$key];
    if (isset($this->$key))
      return $this->$key;
  }

  protected function load_view($filename, $input_data)
  {
    if ($filename == '')
      return;
    //buforowanie wyjścia
    ob_start();
    //importowanie zmiennych z tablicy do bieżącej tablicy symboli
    extract($input_data, EXTR_SKIP);
    include $filename;
    //zwróć bufor
    return ob_get_clean();
  }

  public function render($print=FALSE)
  {
    $output = $this->load_view(URI::getPath().
      '/views/'.$this->filename.'.php', $this->data);
    if ($print==TRUE)
    {
      header('Content-Type: text/html; charset=UTF-8');
      echo $output;
      return;
    }
    return $output;
  }
}
