<?php defined('SYSPATH') or die('No direct script access.');

final class URI
{
  protected static $pathinfo;
  protected static $array;
  protected static $controller;
  protected static $action;
  protected static $arguments;
  protected static $path;

  public static function & instance()
  {
    static $instance;
    if(!isset($instance)) 
    {
      $instance = new URI;
    }
    return $instance;
  }

  protected function __construct() { }

  public static function setup()
  {
    static $run;
    if ($run === TRUE) return;
    self::$pathinfo = $_SERVER['PATH_INFO'];
    self::$pathinfo = preg_replace('#\.[\s./]*/#', '', self::$pathinfo);
    self::$pathinfo = trim(self::$pathinfo, '/');
    //kontroler 
    self::$array = explode('/',self::$pathinfo);
    if (!empty(self::$array[0]))
    {
      $temp = array_shift(self::$array);
      self::$controller = $temp;
      self::$path = APPPATH;
    }
    else
    {
      self::$controller = DEFAULT_CONTROLLER;
      self::$path = APPPATH;
    }
    //akcja
    if (!empty(self::$array[0]))
      self::$action = array_shift(self::$array);
    else
      self::$action = DEFAULT_ACTION;
    //argumenty
    self::$arguments = self::$array;
  }

  public static function getController()
  {
    return self::$controller;
  }

  public static function getAction()
  {
    return self::$action;
  }

  public static function getArguments()
  {
    return self::$arguments;
  }

  public static function getPath()
  {
    return self::$path;
  }
}
