<?php

//definiujemy stałe
define('SYSPATH', 'system');
define('APPPATH', 'application');
define('DEFAULT_CONTROLLER', 'welcome');
define('DEFAULT_ACTION', 'index');

//final - klasa po której nie można dziedziczyć
final class FRAMEWORK
{
  public static $controller;

  public static function & instance()
  {
    static $instance;
    if(!isset($instance)) 
    {
      $instance = new UCEARN;
    }
    return $instance;
  }

  protected function __construct() {}

  public static function setup()
  {
    static $run;
    if ($run === TRUE) return;
    require SYSPATH.'/core/uri.php';
    //Uruchamiamy moduł URI 
    URI::setup();
    //Zarejestrowanie autoloadera
    spl_autoload_register(array('FRAMEWORK', 'autoload'));
    $controller = URI::getController().'_controller';
    //utworzenie kontrolera
    self::$controller = new $controller();
    // tworzymy obiekt refleksji klasy
    $class  = new ReflectionClass(self::$controller);
    //pobieramy metodę
    $method = $class->getMethod(URI::getAction());
    //wykonanie metody z argumentami URI
    $method->invokeArgs(self::$controller,URI::getArguments());
    $run = TRUE;
  }

  private static function loadlibrary($class)
  {
    //wczytujemy bibliotekę
    require_once SYSPATH.'/libraries/'.$class.'.php';
    //rozszerzamy ją jeśli jest to możliwe, w przeciwnym wypadku stosujemy hack
    if (file_exists(URI::getPath().'/libraries/'.$class.'.php'))
      require_once URI::getPath().'/libraries/'.$class.'.php';
    else
      eval($extension = 'class '.$class.' extends '.$class.'_core { }');
  }

  public static function autoload($class)
  {
    //pobieramy typ obiektu
    if (($type = strrpos($class, '_')) !== FALSE)
    {
      $type = substr($class, $type + 1);
    }
    else
      $type = 'default';
    //dla danego typu
    switch($type)
    {
      case 'controller':
        self::loadlibrary('controller');
        $file = substr($class, 0, -11);
        if (file_exists(URI::getPath().'/controllers/'.$file.'.php'))
          require_once URI::getPath().'/controllers/'.$file.'.php';
        else
        {
          header('HTTP/1.1 404 File Not Found');
          exit;
        }
        break;
      case 'model':
        require_once SYSPATH.'/libraries/model.php';
        $file = substr($class, 0, -6);
        require_once URI::getPath().'/models/'.$file.'.php';
        break;
      case 'default':
        self::loadlibrary($class);
        break;
    }
  }
}
//uruchamiamy moduł
FRAMEWORK::setup();